/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "x86emu.h"
#define MAXIMUM_STATIC_SIZE 100
VirtualMemory::VirtualMemory(){
    //it's a dynamic array to vMem* so we will initialize it
    CommittedPages=0x00870000;
    vmem=(vMem**)malloc(MAXIMUM_STATIC_SIZE*4);
    memset((void*)vmem,0,4);
    vmem_length=0;
    cmem=(cMem**)malloc(4);
    memset((void*)cmem,0,4);
    cmem_length=0;
    last_accessed=0;
    last_modified=0;
};
//dword VirtualMemory::add_pointer(dword rptr,dword vptr,dword size){
//      add_pointer(rptr,vptr,size,MEM_READWRITE);
//};
dword VirtualMemory::add_pointer(dword rptr,dword vptr,dword size,int flags){
      if (vmem_length==0){
         vmem[0]=(vMem*)malloc(MAXIMUM_STATIC_SIZE*sizeof(vMem));
         vmem[0]->rmem=rptr;
         vmem[0]->vmem=vptr;
         vmem[0]->size=size;
         vmem[0]->flags=flags;
         vmem_length++;
         
      }else{
         if(vmem_length>=MAXIMUM_STATIC_SIZE){   
             dword c=(dword)vmem;
             vmem=(vMem**)realloc((void*)vmem,(vmem_length+1)*4) ;
             memcpy((void*)c,vmem,(vmem_length)*4);
             vmem[vmem_length]=(vMem*)malloc(sizeof(vMem));
             //if (vmem[vmem_length]==0)vmem[vmem_length]=(vMem*)alloc(sizeof(vMem));
             memset(vmem[vmem_length],0,4);
         }else{
             //vmem=(vMem**)realloc((void*)vmem,(vmem_length+1)*4) ;  
             vmem[vmem_length]=vmem[vmem_length-1]+sizeof(vMem);
         };
         vmem[vmem_length]->rmem=rptr;
         vmem[vmem_length]->vmem=vptr;
         vmem[vmem_length]->size=size;
         vmem[vmem_length]->flags=flags;//*/
         //cout << (int*)vptr << "\n";
         //cout << (int*)vmem_length <<"\n";
         vmem_length++;
         
      };
};
dword VirtualMemory::get_virtual_pointer(dword ptr){
    for (int i=this->vmem_length-1;i>=0;i--){
          if ( ptr >=vmem[i]->rmem && ptr <= (vmem[i]->rmem + vmem[i]->size) && vmem[i]->size!=0){
               ptr -=vmem[i]->rmem;
               ptr +=vmem[i]->vmem;
               return ptr;
          };
      };
      //throw(EXP_INVALIDPOINTER);  //we don't need errors this time
      return 0;
};
dword* VirtualMemory::read_virtual_mem(dword ptr){
      dword vptr=ptr;  
      for (int i=this->vmem_length-1;i>=0;i--){
          //cout << (int*)vptr << "   "<<(int*)vmem[i]->vmem << "\n";
          if ( ptr >=vmem[i]->vmem && ptr <= (vmem[i]->vmem + vmem[i]->size) && vmem[i]->size!=0){
               ptr -=vmem[i]->vmem;
               ptr +=vmem[i]->rmem;
               last_accessed=vptr;
               return (dword*)ptr;
          };
      };
      throw(EXP_INVALIDPOINTER);
};
bool VirtualMemory::get_memory_flags(dword ptr){
      for (int i=0;i<this->cmem_length;i++){
          
          if ( ptr >=cmem[i]->ptr && ptr <= (cmem[i]->ptr + cmem[i]->size)){
               return true;
          };
      };
      //cout << this->cmem_length <<"\n";
      return false;
};
dword VirtualMemory::write_virtual_mem(dword ptr,dword size,char* buff){
      int vptr=ptr;
      int entry=0;
      for (int i=this->vmem_length-1;i>=0;i--){
          if ( ptr >=vmem[i]->vmem && ptr <= (vmem[i]->vmem + vmem[i]->size) && vmem[i]->size!=0){
               ptr -=vmem[i]->vmem;
               ptr +=vmem[i]->rmem;
               entry=i;
              goto mem_found;
          };
      };
      throw(EXP_INVALIDPOINTER);
mem_found:
      if (vmem[entry]->flags==MEM_IMAGEBASE){
         if(!check_writeaccess(vptr,vmem[entry]->vmem))throw(EXP_WRITEACCESS_DENIED);
      };
      if (vmem[entry]->flags==MEM_READONLY || vmem[entry]->flags==MEM_DLLBASE){throw(EXP_WRITEACCESS_DENIED);}
      memcpy((void*)ptr,buff,size);
      last_modified=vptr;
      set_memory_flags((dword)vptr,size);
};
dword VirtualMemory::set_memory_flags(dword ptr,int size){
      for (int i=0;i<this->cmem_length;i++){
           if ( ptr >=cmem[i]->ptr && ptr < (cmem[i]->ptr + cmem[i]->size)){
              //so it's allready written 
              goto  found_ptr;
           }else if (ptr == (cmem[i]->ptr + cmem[i]->size)){ //here if it's the next dword or the next byte (for loop on decrypting something
                 cmem[i]->size+=size;
                 goto  found_ptr;
           }else if ((ptr+size) ==cmem[i]->ptr){ // the prev byte or dword (decrypting from the end to the top)
                 cmem[i]->ptr -=size;
                 cmem[i]->size+=size;
                 goto  found_ptr;  
           };
      };
      //if not found so add it 
      if (cmem_length==0){
          cmem[0]=(cMem*)malloc(sizeof(cMem));
          cmem[0]->ptr=ptr;
          cmem[0]->size=size;
          cmem_length++;
      }else{
          cmem=(cMem**)realloc((void*)cmem,(cmem_length+1)*4) ;
          cmem[cmem_length]=(cMem*)malloc(sizeof(cMem));
          cmem[cmem_length]->ptr=ptr;
          cmem[cmem_length]->size=size;
          cmem_length++;
      };
found_ptr:;    
};

bool VirtualMemory::check_writeaccess(dword ptr,dword imagebase){
     //cout << (int*)ptr << "\n"<< (int*)imagebase << "\n";
     image_header *PEHeader;
     dword FileHandler,PEHeader_ptr;
    image_section_header* data;
    if (ptr < (imagebase+0x1000)) return false;
    ptr-=imagebase;
    FileHandler=(dword)read_virtual_mem(imagebase);
    PEHeader_ptr=((dos_header*)FileHandler)->e_lfanew + FileHandler;
    PEHeader=(image_header*)PEHeader_ptr;
    for (int i=0;i < PEHeader->header.number_of_sections-1;i++){
         if (ptr >=PEHeader->sections[i].virtual_address && ptr <(PEHeader->sections[i+1].virtual_address)){
                  if(PEHeader->sections[i].characteristics & IMAGE_SCN_MEM_WRITE){
                      return true;                                        
                  }else{
                       return false; 
                  };
         };
    };
    int n=PEHeader->header.number_of_sections-1;
    dword s=(dword)&PEHeader->sections[2];
    s+=sizeof(image_section_header)+1;
    image_section_header* f=(image_section_header*)s;
    if (ptr >=PEHeader->sections[n].virtual_address && ptr <=(PEHeader->optional.size_of_image)){
             if(PEHeader->sections[n].characteristics & IMAGE_SCN_MEM_WRITE){//
                    return true;                                       
             }else{
                    return false;    
             };
    };
    return false; 
};
dword VirtualMemory::delete_pointer(dword ptr){
      for (int i=this->vmem_length-1;i>=0;i--){
          if ( ptr >=vmem[i]->vmem && ptr <= (vmem[i]->vmem + vmem[i]->size) && vmem[i]->size!=0){
             vmem[i]->size=0;
             return 0;
          };
      };
      return -1;
};
dword VirtualMemory::get_last_accessed(){
      return last_accessed;
};
dword VirtualMemory::get_last_modified(){
      return last_modified;
};
